/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.xmlreport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import oracle.ops.verification.framework.report.xmlreport.XmlReportToolException;

public final class CVXMLReportWriter {
    private XMLStreamWriter writer = null;
    private static final Object SEEN_NOTHING = new Object();
    private static final Object SEEN_ELEMENT = new Object();
    private static final Object SEEN_DATA = new Object();
    private Object state = SEEN_NOTHING;
    private Stack<Object> stateStack = new Stack();
    private String indentStep = "  ";
    private int depth = 0;

    public CVXMLReportWriter(OutputStream outputStream) throws IOException, XmlReportToolException {
        XMLOutputFactory xmlof = XMLOutputFactory.newInstance();
        try {
            this.writer = xmlof.createXMLStreamWriter(outputStream);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public int getIndentStep() {
        return this.indentStep.length();
    }

    public void setIndentStep(int indentStep) {
        StringBuilder s = new StringBuilder();
        while (indentStep > 0) {
            s.append(' ');
            --indentStep;
        }
        this.setIndentStep(s.toString());
    }

    public void setIndentStep(String s) {
        this.indentStep = s;
    }

    private void onStartElement() throws XmlReportToolException {
        this.stateStack.push(SEEN_ELEMENT);
        this.state = SEEN_NOTHING;
        if (this.depth > 0) {
            try {
                this.writer.writeCharacters("\n");
            }
            catch (XMLStreamException e) {
                throw new XmlReportToolException(e);
            }
        }
        this.doIndent();
        ++this.depth;
    }

    private void onEndElement() throws XmlReportToolException {
        --this.depth;
        if (this.state == SEEN_ELEMENT) {
            try {
                this.writer.writeCharacters("\n");
            }
            catch (XMLStreamException e) {
                throw new XmlReportToolException(e);
            }
            this.doIndent();
        }
        this.state = this.stateStack.pop();
    }

    private void onEmptyElement() throws XmlReportToolException {
        this.state = SEEN_ELEMENT;
        if (this.depth > 0) {
            try {
                this.writer.writeCharacters("\n");
            }
            catch (XMLStreamException e) {
                throw new XmlReportToolException(e);
            }
        }
        this.doIndent();
    }

    private void doIndent() throws XmlReportToolException {
        if (this.depth > 0) {
            for (int i = 0; i < this.depth; ++i) {
                try {
                    this.writer.writeCharacters(this.indentStep);
                    continue;
                }
                catch (XMLStreamException e) {
                    throw new XmlReportToolException(e);
                }
            }
        }
    }

    public void writeStartDocument() throws XmlReportToolException {
        try {
            this.writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
        try {
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeStartDocument(String version) throws XmlReportToolException {
        try {
            this.writer.writeStartDocument(version);
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeStartDocument(String encoding, String version) throws XmlReportToolException {
        try {
            this.writer.writeStartDocument(encoding, version);
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeStartElement(String localName) throws XmlReportToolException {
        this.onStartElement();
        try {
            this.writer.writeStartElement(localName);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeStartElement(String namespaceURI, String localName) throws XmlReportToolException {
        this.onStartElement();
        try {
            this.writer.writeStartElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XmlReportToolException {
        this.onStartElement();
        try {
            this.writer.writeStartElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XmlReportToolException {
        this.onEmptyElement();
        try {
            this.writer.writeEmptyElement(namespaceURI, localName);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XmlReportToolException {
        this.onEmptyElement();
        try {
            this.writer.writeEmptyElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeEmptyElement(String localName) throws XmlReportToolException {
        this.onEmptyElement();
        try {
            this.writer.writeEmptyElement(localName);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeAttribute(String name, String value) throws XmlReportToolException {
        try {
            this.writer.writeAttribute(name, value);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeEndElement() throws XmlReportToolException {
        this.onEndElement();
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeCharacters(String text) throws XmlReportToolException {
        this.state = SEEN_DATA;
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeCharacters(char[] text, int start, int len) throws XmlReportToolException {
        this.state = SEEN_DATA;
        try {
            this.writer.writeCharacters(text, start, len);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeCData(String data) throws XmlReportToolException {
        this.state = SEEN_DATA;
        try {
            this.writer.writeCData(data);
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void close() throws XmlReportToolException {
        try {
            this.writer.close();
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }

    public void writeEndDocument() throws XmlReportToolException {
        try {
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new XmlReportToolException(e);
        }
    }
}

